if not GetUserPref("LastRunVersion") then
	Trace("LastRunVersion not previously set; setting to current version.");
	SetUserPref("LastRunVersion", themeInfo.Version);
else
	local lastRunVer = GetUserPref("LastRunVersion");
	if string.sub(lastRunVer, 1, 1) == "v" then
		lastRunVer = tonumber(string.sub(lastRunVer,2));
	end;
	if tonumber(lastRunVer) < themeInfo.Version then
		-- last run version doesn't match new version. set new version so
		-- this doesn't happen again, then show the changelog.
		Trace("new version > LastRunVersion; set and changelog");
		SetUserPref("LastRunVersion", themeInfo.Version);
	end;
end;

local t = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(FullScreen;diffuse,color("#ffffffFF"));
		OnCommand=cmd(decelerate,1;diffuse,color("#fffffb00"));
	};
};

return t;